/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.OwnerManager;
import com.ibm.hsc.websm.updates.PIMOChangeMgmtInfo;
import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hwmca.base.updates.UCConcurrencyInfo;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdatePanelUtilities
implements FirmwareUpdateConstants {
    private static final String TRACE_MASKT = "XUPDUPUT";
    private static final String TRACE_MASKF = "XUPDUPUF";
    private static final String TRACE_MASKD = "XUPDUPUD";
    public static final int GCI_MODE_APPLY = 1;
    public static final int GCI_MODE_REJECT = 2;
    public static final int GCI_MODE_APPLY_SPECIFIC = 8;
    public static final int GCI_MODE_ACCEPT = 9;
    public static final int GCI_MODE_ACTIVATE = 10;
    private static Map specificLevelMap = null;

    static LocalizableText getRepositoryLocationText(int n) {
        String string;
        Trace.trace((String)TRACE_MASKT, (Object)"<> UpdatePanelUtilities.getRepositoryLocationText");
        switch (n) {
            case 0: {
                string = "WEB_SITE_TEXT";
                break;
            }
            case 5: {
                string = "SUPPORT_SYSTEM_TEXT";
                break;
            }
            case 1: {
                string = "DVD_DRIVE_TEXT";
                break;
            }
            case 4: {
                string = "FTP_SITE_TEXT";
                break;
            }
            case 3: {
                string = "HARD_DRIVE_TEXT";
                break;
            }
            default: {
                string = "NO_REPOS_TEXT";
            }
        }
        LocalizableText localizableText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", string);
        return localizableText;
    }

    static PIUpdatesOwner getPIOwnerForManagedObject(ManagedObject managedObject) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> UpdatePanelUtilities.getPIOwnerForManagedObject() for: " + managedObject));
        OwnerManager ownerManager = OwnerManager.getOwnerManager();
        UpdatesOwner updatesOwner = ownerManager.getOwnerForManagedObject(managedObject);
        if (updatesOwner instanceof PIUpdatesOwner) {
            return (PIUpdatesOwner)updatesOwner;
        }
        return null;
    }

    static List doSurvey(ManagedObject managedObject, RepositoryItem repositoryItem, boolean bl) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> UpdatePanelUtilities.doSurvey for: " + managedObject));
        List list = Collections.EMPTY_LIST;
        PIUpdatesOwner pIUpdatesOwner = UpdatePanelUtilities.getPIOwnerForManagedObject(managedObject);
        if (null != pIUpdatesOwner) {
            if (repositoryItem.getReposType() == -1) {
                Trace.trace((String)TRACE_MASKD, (Object)" [doSurvey()] call owner.getUpdateableComponents()");
                list = pIUpdatesOwner.getUpdateableComponents();
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)" [doSurvey()] call owner.getUpdateableComponents(reposItem)");
                list = pIUpdatesOwner.getUpdateableComponents(repositoryItem, bl);
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)(" UpdatePanelUtilities.doSurvey() - returning " + list.size() + " components"));
        return list;
    }

    static List getComponentsByManagedObject(ManagedObject managedObject) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> UpdatePanelUtilities.getComponentsByManagedObject(mo) for: " + managedObject));
        List list = Collections.EMPTY_LIST;
        PIUpdatesOwner pIUpdatesOwner = UpdatePanelUtilities.getPIOwnerForManagedObject(managedObject);
        if (null != pIUpdatesOwner) {
            try {
                Trace.trace((String)TRACE_MASKD, (Object)" [getComponentsByManagedObject(mo)] call owner.getUpdateableComponents()");
                list = pIUpdatesOwner.getUpdateableComponents();
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKF, (String)"[getComponentsByManagedObject(mo)] Caught exception: ", (Object)((Object)hException));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- UpdatePanelUtilities.getComponentsByManagedObject(mo) returning " + list.size() + " components."));
        return list;
    }

    static void forceComponentListCreation(ManagedObject[] managedObjectArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> UpdatePanelUtilities.forceComponentListCreation()");
        for (int i = 0; i < managedObjectArray.length; ++i) {
            UpdatePanelUtilities.getComponentsByManagedObject(managedObjectArray[i], true);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- UpdatePanelUtilities.forceComponentListCreation()");
    }

    static List getComponentsByManagedObject(ManagedObject managedObject, boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> UpdatePanelUtilities.getComponentsByManagedObject(mo, boolean) for: " + managedObject));
        List list = Collections.EMPTY_LIST;
        PIUpdatesOwner pIUpdatesOwner = UpdatePanelUtilities.getPIOwnerForManagedObject(managedObject);
        if (null != pIUpdatesOwner) {
            try {
                Trace.trace((String)TRACE_MASKD, (Object)(" [getComponentsByManagedObject(mo, bool)] call owner.getUpdateableComponents(" + bl + ")"));
                list = pIUpdatesOwner.getUpdateableComponents(bl);
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKF, (String)"[getComponentsByManagedObject(mo, bool)] Caught exception: ", (Object)((Object)hException));
            }
        }
        return list;
    }

    static boolean isConcurrentUpdatingEnabled(ManagedObject[] managedObjectArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"<> UpdatePanelUtilities.isConcurrentUpdatingEnabled(MangedObject[])");
        boolean bl = true;
        int n = managedObjectArray.length;
        for (int i = 0; i < n; ++i) {
            ManagedObject managedObject = managedObjectArray[i];
            if (UpdatePanelUtilities.isConcurrentUpdatingEnabled(managedObject)) continue;
            bl = false;
            Trace.trace((String)TRACE_MASKF, (Object)(" [UpdatePanelUtilities.isConcurrentUpdatingEnabled()] Found target '" + managedObject.getUIInfo().getName() + "' to be disabled for concurrent updates."));
            break;
        }
        return bl;
    }

    static boolean isConcurrentUpdatingEnabled(ManagedObject managedObject) {
        List list = UpdatePanelUtilities.getComponentsByManagedObject(managedObject);
        return UpdatePanelUtilities.isConcurrentUpdatingEnabled(list);
    }

    static boolean isConcurrentUpdatingEnabled(List list) {
        Trace.trace((String)TRACE_MASKT, (Object)"<> UpdatePanelUtilities.isConcurrentUpdatingEnabled(List)");
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)iterator.next();
            if (pIUpdateableComponent.isConcurrentUpdatingEnabled()) continue;
            bl = false;
            Trace.trace((String)TRACE_MASKF, (Object)(" [UpdatePanelUtilities.isConcurrentUpdatingEnabled()] Found component '" + pIUpdateableComponent.getName() + "' to be disabled for concurrent updates."));
            break;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<> UpdatePanelUtilities.isConcurrentUpdatingEnabled returns: " + bl));
        return bl;
    }

    static PIMOChangeMgmtInfo getConcurrencyInfo(ManagedObject managedObject, int n) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> UpdatePanelUtilities.getConcurrencyInfo(ManagedObject) for: " + managedObject));
        PIMOChangeMgmtInfo pIMOChangeMgmtInfo = new PIMOChangeMgmtInfo();
        pIMOChangeMgmtInfo.setUpdateTarget(managedObject);
        pIMOChangeMgmtInfo.setMode(n);
        pIMOChangeMgmtInfo.setName(managedObject.getUIInfo().getName());
        ArrayList arrayList = n != 8 ? UpdatePanelUtilities.getComponentsByManagedObject(managedObject) : new ArrayList(specificLevelMap.keySet());
        Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - the target: " + managedObject));
        Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - the mode: " + n));
        Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - the name: " + managedObject.getUIInfo().getName()));
        Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - the components variable: " + arrayList));
        Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - the components size: " + arrayList.size()));
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - there are " + arrayList.size() + " entries in the list of updateable components for " + managedObject.getUIInfo().getName()));
        if (0 == arrayList.size()) {
            pIMOChangeMgmtInfo.setStatus(0);
        } else {
            UCConcurrencyInfo[] uCConcurrencyInfoArray = new UCConcurrencyInfo[arrayList.size()];
            pIMOChangeMgmtInfo.setConcurrencyInfo(uCConcurrencyInfoArray);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)iterator.next();
                Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - element " + ++n2 + " is for component " + pIUpdateableComponent.getDisplayableId()));
                uCConcurrencyInfoArray[n2] = UpdatePanelUtilities.extractConcurrencyInfo(pIUpdateableComponent, n);
                int n3 = uCConcurrencyInfoArray[n2].getStatus();
                switch (n3) {
                    case 2: {
                        bl = true;
                        if (!bl2) break;
                        bl3 = true;
                        break;
                    }
                    case 3: {
                        bl2 = true;
                        if (!bl) break;
                        bl3 = true;
                        break;
                    }
                    case 4: {
                        bl3 = true;
                        break;
                    }
                }
                Trace.trace((String)TRACE_MASKD, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - Status from extractConcurrencyInfo() is " + n3 + ", flags are (allConcurrent, allDisruptive, someOfEach) " + bl + ", " + bl2 + ", " + bl3));
            }
            if (bl3) {
                pIMOChangeMgmtInfo.setStatus(4);
            } else if (bl) {
                pIMOChangeMgmtInfo.setStatus(2);
            } else if (bl2) {
                pIMOChangeMgmtInfo.setStatus(3);
                if (n == 1 && !UpdatePanelUtilities.isConcurrentUpdatingEnabled(arrayList)) {
                    pIMOChangeMgmtInfo.setStatus(5);
                }
            } else {
                pIMOChangeMgmtInfo.setStatus(1);
                pIMOChangeMgmtInfo.setSelectedForCecPower(false);
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.getConcurrencyInfo() - Output status is " + pIMOChangeMgmtInfo.getStatus() + ", " + "operation mode is " + pIMOChangeMgmtInfo.getMode() + ", " + "isSelectedForCecPower is " + pIMOChangeMgmtInfo.isSelectedForCecPower()));
        Trace.trace((String)TRACE_MASKT, (Object)"<- UpdatePanelUtilities.getConcurrencyInfo(ManagedObject)");
        return pIMOChangeMgmtInfo;
    }

    static PIMOChangeMgmtInfo[] getConcurrencyInfo(ManagedObject[] managedObjectArray, int n, Map map) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> UpdatePanelUtilities.getConcurrencyInfo(ManagedObject[])");
        if (n == 8) {
            specificLevelMap = map;
        }
        PIMOChangeMgmtInfo[] pIMOChangeMgmtInfoArray = new PIMOChangeMgmtInfo[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            pIMOChangeMgmtInfoArray[i] = UpdatePanelUtilities.getConcurrencyInfo(managedObjectArray[i], n);
        }
        if (n == 8) {
            specificLevelMap = null;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- UpdatePanelUtilities.getConcurrencyInfo(ManagedObject[])");
        return pIMOChangeMgmtInfoArray;
    }

    public static UCConcurrencyInfo extractConcurrencyInfo(PIUpdateableComponent pIUpdateableComponent, int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> UpdatePanelUtilities.extractConcurrencyInfo()");
        UCConcurrencyInfo uCConcurrencyInfo = new UCConcurrencyInfo();
        uCConcurrencyInfo.setComponent((UpdateableComponent)pIUpdateableComponent);
        int n2 = pIUpdateableComponent.getStagableLevel();
        int n3 = pIUpdateableComponent.getNonDisruptiveStagableLevel();
        int n4 = pIUpdateableComponent.getApplyInProgressLevel();
        int n5 = pIUpdateableComponent.getAppliedLevel();
        int n6 = pIUpdateableComponent.getCommittedLevel();
        int n7 = pIUpdateableComponent.getNonDisruptiveRejectLevel();
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.extractConcurrencyInfo() - Updateable Component is [" + pIUpdateableComponent.getDisplayableId() + "], " + "mode is " + n));
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.extractConcurrencyInfo() - stageable level is " + n2 + ", " + "non-disruptive stageable level is " + n3 + ", " + "apply in progress level is " + n4));
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.extractConcurrencyInfo() - applied level is " + n5 + ", " + "committed level is " + n6 + ", " + "non-disruptive reject level is " + n7));
        if (1 == n) {
            if (0 >= n2 || n2 == n5) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply.1");
                uCConcurrencyInfo.setStatus(1);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else if (n5 >= 900) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply.2");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5);
            } else if (n5 == n3 || -1 == n3) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply.3");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5 + 1);
            } else if (n2 == n3) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply.4");
                uCConcurrencyInfo.setStatus(2);
                uCConcurrencyInfo.setLastConcurrent(n2);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply.5");
                uCConcurrencyInfo.setStatus(4);
                uCConcurrencyInfo.setLastConcurrent(n3);
                uCConcurrencyInfo.setFirstDisruptive(n3 + 1);
            }
        } else if (8 == n) {
            int n8 = (Integer)specificLevelMap.get(pIUpdateableComponent);
            if (n8 == -1) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.1");
                uCConcurrencyInfo.setStatus(1);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else if (n5 >= 900) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.2");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5);
            } else if (n8 < n5) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.6");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n8);
            } else if (n5 == n3 || -1 == n3) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.3");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5 + 1);
            } else if (n8 <= n3) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.4");
                uCConcurrencyInfo.setStatus(2);
                uCConcurrencyInfo.setLastConcurrent(n8);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Apply Specific.5");
                uCConcurrencyInfo.setStatus(4);
                uCConcurrencyInfo.setLastConcurrent(n3);
                uCConcurrencyInfo.setFirstDisruptive(n3 + 1);
            }
        } else if (2 == n) {
            if (n6 == n5 && n5 == n4) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.1");
                uCConcurrencyInfo.setStatus(1);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else if (n5 >= 900 || n4 >= 900) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.2");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5);
            } else if (-1 == n7) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.3");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5);
            } else if (n5 != n4) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.4");
                uCConcurrencyInfo.setStatus(3);
                uCConcurrencyInfo.setLastConcurrent(-1);
                uCConcurrencyInfo.setFirstDisruptive(n5);
            } else if (1 == n7) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.5");
                uCConcurrencyInfo.setStatus(2);
                uCConcurrencyInfo.setLastConcurrent(1);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else if (n7 == n6 + 1) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.6");
                uCConcurrencyInfo.setStatus(2);
                uCConcurrencyInfo.setLastConcurrent(n6 + 1);
                uCConcurrencyInfo.setFirstDisruptive(-1);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Reject.7");
                uCConcurrencyInfo.setStatus(4);
                uCConcurrencyInfo.setLastConcurrent(n7);
                uCConcurrencyInfo.setFirstDisruptive(n7 - 1);
            }
        } else if (9 == n) {
            if (n5 >= 900) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Accept.1");
                uCConcurrencyInfo.setStatus(20);
            }
            if (n6 == n5) {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Accept.2");
                uCConcurrencyInfo.setStatus(1);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Accept.3");
                uCConcurrencyInfo.setStatus(2);
            }
        } else if (10 == n) {
            Trace.trace((String)TRACE_MASKF, (Object)"  [extractConcurrencyInfo()] Case Activate.1");
            uCConcurrencyInfo.setStatus(3);
        }
        Trace.trace((String)TRACE_MASKF, (Object)("   UpdatePanelUtilities.extractConcurrencyInfo() - For mode " + n + ", " + "Status is " + uCConcurrencyInfo.getStatus() + ", " + "Last concurrent value is " + uCConcurrencyInfo.getLastConcurrent() + ", " + "First disruptive value is " + uCConcurrencyInfo.getFirstDisruptive()));
        Trace.trace((String)TRACE_MASKT, (Object)"<- UpdatePanelUtilities.extractConcurrencyInfo()");
        return uCConcurrencyInfo;
    }
}

